/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.base;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.mosp.common.common.MospException;
import jp.mosp.express.ExpressUtility;
import jp.mosp.payroll.dto.DetailDto;
import jp.mosp.payroll.dto.DetailMoneyDto;
import jp.mosp.payroll.dto.DetailTimeDto;

/**
 * ^vZ֘A`[̌ƂȂNXB<br><br>
 */
public abstract class PayrollSlip {
	
	/**
	 * ׏擾B
	 * @param detailCode ׃R[h
	 */
	protected DetailDto getDetailDto(List<?> list, String detailCode) {
		for (Iterator<?> it = list.iterator(); it.hasNext();) {
			DetailDto dto = (DetailDto)it.next();
			if (dto.getDetailCode().equals(detailCode)) {
				return dto;
			}
		}
		return null;
	}
	
	/**
	 * ׃Xgݒ肷B
	 * @param aryDetail ݒΏۖהz
	 */
	protected void setDetails(List<?> listDetail, String[][] aryDetail) {
		for (Iterator<?> it = listDetail.iterator(); it.hasNext();) {
			DetailDto dto = (DetailDto)it.next();
			for (int i = 0; i < aryDetail.length; i++) {
				if (dto.getDetailCode().equals(aryDetail[i][0])) {
					setDetailAmount(dto, Float.parseFloat(aryDetail[i][2]));
					break;
				}
			}
		}
	}
	
	/**
	 * גl擾B
	 * @param list 擾ΏۃXg
	 * @param detailCode 擾Ώۖ׃R[h
	 * @return גl
	 */
	protected float getDetailAmount(List<?> list, String detailCode) {
		for (Iterator<?> it = list.iterator(); it.hasNext();) {
			DetailDto dto = (DetailDto)it.next();
			if (dto.getDetailCode().equals(detailCode)) {
				if (dto instanceof DetailTimeDto) {
					DetailTimeDto detailTimeDto = (DetailTimeDto)dto;
					return detailTimeDto.getAmount();
				}
				if (dto instanceof DetailMoneyDto) {
					DetailMoneyDto detailMoneyDto = (DetailMoneyDto)dto;
					return detailMoneyDto.getAmount();
				}
			}
		}
		return 0;
	}
	
	/**
	 * הz擾B
	 * @param list             擾ΏۃXg
	 * @param checkDisplayType 0󎚋敪mFv
	 * @return הz
	 */
	protected String[][] getAryDetail(List<?> list, boolean checkDisplayType) {
		String[][] aryDetail = new String[list.size()][3];
		for (int i = 0; i < list.size(); i++) {
			DetailDto dto = (DetailDto)list.get(i);
			aryDetail[i][0] = dto.getDetailCode();
			aryDetail[i][1] = dto.getDetailAbbr();
			aryDetail[i][2] = "0";
			if (dto instanceof DetailTimeDto) {
				aryDetail[i][2] = String.valueOf(((DetailTimeDto)dto).getAmount());
			}
			if (dto instanceof DetailMoneyDto) {
				aryDetail[i][2] = String.valueOf(((DetailMoneyDto)dto).getAmount());
			}
			if (checkDisplayType && dto.getDisplayType() == PayrollConst.DETAIL_DISP_NONE) {
				if (String.valueOf(aryDetail[i][2]).equals("0")) {
					aryDetail[i][1] = "";
					aryDetail[i][2] = "";
				}
			}
		}
		return aryDetail;
	}
	
	/**
	 * גlݒ肷B
	 * @param list       ׏
	 * @param listAmount גlXg
	 */
	protected void setDetailsAmount(List<?> list, List<?> listAmount) {
		for (Iterator<?> it = list.iterator(); it.hasNext();){
			DetailDto dto = (DetailDto)it.next();
			for (Iterator<?> itAmount = listAmount.iterator(); itAmount.hasNext();) {
				DetailDto dtoAmount = (DetailDto)itAmount.next();
				if (dto.getDetailCode().equals(dtoAmount.getDetailCode())) {
					if (dtoAmount instanceof DetailTimeDto) {
						setDetailAmount(dto, ((DetailTimeDto)dtoAmount).getAmount());
						break;
					}
					if (dtoAmount instanceof DetailMoneyDto) {
						setDetailAmount(dto, ((DetailMoneyDto)dtoAmount).getAmount());
						break;
					}
				}
			}
		}
	}
	
	/**
	 * גlvZB
	 * @param listDetail ׃Xg
	 * @param mapParams  p[^Map
	 * @throws MospException 
	 */
	protected void calcDetails(List<?> listDetail, Map<String, String> mapParams) throws MospException {
		for (Iterator<?> it = listDetail.iterator(); it.hasNext();){
			DetailDto dto = (DetailDto)it.next();
			setDetailAmount(dto, calcExpr(dto.getExpression(), mapParams));
		}
	}
	
	/**
	 * גlݒ肷B
	 * @param detailDto ݒΏۖDTO
	 * @param amount    ݒl
	 * @throws MospException 
	 */
	protected void setDetailAmount(DetailDto detailDto, float amount) {
		if (detailDto instanceof DetailTimeDto) {
			DetailTimeDto dto = (DetailTimeDto)detailDto;
			dto.setAmount(amount);
			return;
		}
		if (detailDto instanceof DetailMoneyDto) {
			DetailMoneyDto dto = (DetailMoneyDto)detailDto;
			dto.setAmount((int)amount);
			return;
		}
	}
	
	/**
	 * ׂB
	 * @param list     Ώۖ׃Xg
	 * @param kCode    tЈR[h
	 * @param calcDate tvZN
	 */
	protected void initDetails(List<?> list, String kCode, Date calcDate) {
		for (Iterator<?> it = list.iterator(); it.hasNext();){
			initDetail((DetailDto)it.next(), kCode, calcDate);
		}
	}
	
	/**
	 * ׂB
	 * @param Ώۖ
	 */
	private void initDetail(DetailDto dto, String kCode, Date calcDate) {
		dto.setKCode   (kCode   );
		dto.setCalcDate(calcDate);
		if (dto instanceof DetailTimeDto) {
			((DetailTimeDto)dto).setAmount(0F);
			return;
		}
		if (dto instanceof DetailMoneyDto) {
			((DetailMoneyDto)dto).setAmount(0);
			return;
		}
	}
	
	/**
	 * vZvZB<br>
	 * @param expression vZ
	 * @param mapParams  p[^
	 * @return vZl
	 * @throws MospException 
	 */
	protected float calcExpr(
			String expression, Map<String, String> mapParams
	) throws MospException {
		return ExpressUtility.calculate(
				expression, mapParams, new HashMap<String, String[][]>());
	}
	
}
